/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.data;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;
import noppes.npcs.LogWriter;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.handler.data.IDataElement;
import noppes.npcs.api.wrapper.DataObject;
import noppes.npcs.util.Util;

public class DataElement
implements IDataElement {
    private final Object data;
    private String name;
    private final Object object;
    private Class<?> parent;

    public DataElement(Object object, Object clazz) {
        this.object = object;
        this.data = clazz;
        this.parent = null;
        if (object instanceof Method) {
            this.name = ((Method)object).getName();
            this.parent = ((Method)object).getDeclaringClass();
        } else if (object instanceof Field) {
            this.name = ((Field)object).getName();
            this.parent = ((Field)object).getDeclaringClass();
        } else if (object instanceof Constructor) {
            this.name = "";
            this.parent = ((Constructor)object).getDeclaringClass();
        } else if (object instanceof Class) {
            this.name = object.getClass().getName();
            this.parent = clazz.getClass();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.object instanceof Method) {
            Parameter[] p1;
            if (!(object instanceof Method)) {
                return false;
            }
            Method m0 = (Method)this.object;
            Method m1 = (Method)object;
            Parameter[] p0 = m0.getParameters();
            if (p0.length != (p1 = m1.getParameters()).length) {
                return false;
            }
            for (int p = 0; p < p0.length; ++p) {
                if (p0[p].getType() == p1[p].getType()) continue;
                return false;
            }
            return m0.getName().equals(m1.getName()) && m0.getReturnType() == m1.getReturnType() && m0.getDeclaringClass() == m1.getDeclaringClass();
        }
        if (this.object instanceof Field) {
            if (!(object instanceof Field)) {
                return false;
            }
            Field f0 = (Field)this.object;
            Field f1 = (Field)object;
            return f0.getName().equals(f1.getName()) && f0.getType() == f1.getType() && f0.getDeclaringClass() == f1.getDeclaringClass();
        }
        if (this.object instanceof Constructor) {
            Parameter[] p1;
            if (!(object instanceof Constructor)) {
                return false;
            }
            Constructor c0 = (Constructor)this.object;
            Constructor c1 = (Constructor)object;
            Parameter[] p0 = c0.getParameters();
            if (p0.length != (p1 = c1.getParameters()).length) {
                return false;
            }
            for (int p = 0; p < p0.length; ++p) {
                if (p0[p].getType() == p1[p].getType()) continue;
                return false;
            }
            return c0.getDeclaringClass() == c1.getDeclaringClass();
        }
        return this.equals(object);
    }

    @Override
    public String getData() {
        String key;
        if (this.object instanceof Method) {
            Method m = (Method)this.object;
            int md = m.getModifiers();
            key = Modifier.isPrivate(md) ? "private " : (Modifier.isProtected(md) ? "protected " : (Modifier.isPublic(md) ? "public " : "default "));
            if (Modifier.isStatic(md)) {
                key = key + "static ";
            }
            if (Modifier.isSynchronized(md)) {
                key = key + "synchronized ";
            }
            if (Modifier.isFinal(md)) {
                key = key + "final ";
            }
            StringBuilder body = new StringBuilder("(");
            for (Parameter p : m.getParameters()) {
                if (!body.toString().equals("(")) {
                    body.append(", ");
                }
                body.append(p.getType().getName());
            }
            body.append(")");
            key = key + Util.getAgrName(m.getReturnType()) + " " + m.getName() + body;
            String obfName = DataObject.getObfuscatedName(m.getName());
            if (!obfName.isEmpty()) {
                key = key + " {obf_name=\"" + obfName + "\"}";
            }
        } else if (this.object instanceof Field) {
            Field f = (Field)this.object;
            int md = f.getModifiers();
            key = Modifier.isPrivate(md) ? "private " : (Modifier.isProtected(md) ? "protected " : (Modifier.isPublic(md) ? "public " : "default "));
            if (Modifier.isStatic(md)) {
                key = key + "static ";
            }
            if (Modifier.isFinal(md)) {
                key = key + "final ";
            }
            key = key + Util.getAgrName(f.getType()) + " " + f.getName();
            String obfName = DataObject.getObfuscatedName(f.getName());
            if (!obfName.isEmpty()) {
                key = key + " {obf_name=\"" + obfName + "\"}";
            }
            f.setAccessible(true);
        } else if (this.object instanceof Constructor) {
            Class<?>[] params;
            StringBuilder body = new StringBuilder("(");
            int md = ((Constructor)this.object).getModifiers();
            key = Modifier.isPrivate(md) ? "private " : (Modifier.isProtected(md) ? "protected " : (Modifier.isPublic(md) ? "public " : "default "));
            for (Class<?> p : params = ((Constructor)this.object).getParameterTypes()) {
                if (!body.toString().equals("(")) {
                    body.append(", ");
                }
                body.append(Util.getAgrName(p));
            }
            body.append(")");
            key = key + this.data.getClass().getSimpleName() + body;
        } else if (this.object instanceof Class) {
            int md = ((Class)this.object).getModifiers();
            key = Modifier.isPrivate(md) ? "private " : (Modifier.isProtected(md) ? "protected " : (Modifier.isPublic(md) ? "public " : "default "));
            key = key + Util.getAgrName((Class)this.object);
        } else {
            key = this.data.toString();
        }
        return key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public Class<?> getParent() {
        try {
            return this.parent != null ? this.parent : Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException e) {
            LogWriter.error(e);
            return null;
        }
    }

    @Override
    public int getType() {
        if (this.object instanceof Constructor) {
            return 0;
        }
        if (this.object instanceof Class) {
            return 1;
        }
        if (this.object instanceof Field) {
            return 2;
        }
        if (this.object instanceof Method) {
            return 3;
        }
        return -1;
    }

    @Override
    public Object getValue() {
        if (this.object instanceof Method) {
            return ((Method)this.object).getReturnType();
        }
        if (this.object instanceof Field) {
            if (this.data.getClass() == Class.class) {
                return null;
            }
            try {
                Field field = (Field)this.object;
                field.setAccessible(true);
                Object obj = field.get(this.data);
                if (obj == null) {
                    return "null";
                }
                String value = obj.toString();
                if (obj.getClass().isArray()) {
                    Class<?> ct = obj.getClass().getComponentType();
                    String key = Util.getAgrName(ct);
                    return key + "[]" + value.substring(value.indexOf("@"));
                }
                if (obj instanceof List || obj instanceof Map) {
                    return Util.getAgrName(obj.getClass()) + value;
                }
                return value;
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
        return this.object;
    }

    @Override
    public Object invoke(Object[] values) {
        if (this.object instanceof Method) {
            ((Method)this.object).setAccessible(true);
            try {
                ((Method)this.object).invoke(this.data, values);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
        return null;
    }

    @Override
    public boolean isBelong(Class<?> cz) {
        if (this.parent == null) {
            return false;
        }
        return this.parent.isAssignableFrom(cz);
    }

    @Override
    public boolean setValue(Object value) {
        if (this.object instanceof Field) {
            Field f = (Field)this.object;
            int mod = f.getModifiers();
            if (Modifier.isFinal(mod)) {
                try {
                    Field modifiersField = Field.class.getDeclaredField("modifiers");
                    modifiersField.setAccessible(true);
                    modifiersField.setInt(f, mod - 16 - (Modifier.isPrivate(mod) ? 2 : 0));
                    f.setAccessible(true);
                    f.set(Modifier.isStatic(mod) ? null : this.data, value);
                    modifiersField.setInt(f, mod);
                    return true;
                }
                catch (Exception e) {
                    LogWriter.error(e);
                    return false;
                }
            }
            try {
                f.setAccessible(true);
                f.set(this.data, value);
                return true;
            }
            catch (Exception e) {
                throw new CustomNPCsException(e, "Error set value.", new Object[0]);
            }
        }
        return false;
    }
}

